<?php
 function igmg_wp_title( $title, $sep ) {
	global $paged, $page;

	if ( is_feed() )
		return $title;

	// Add the site name.
	$title .= get_bloginfo( 'name' );

	// Add the site description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title &mdash; $site_description";

	// Add a page number if necessary.
	if ( $paged >= 2 || $page >= 2 )
		$title = "$title &mdash; " . sprintf( __( 'Page %s', 'wpigmg' ), max( $paged, $page ) );

	return $title;
}
add_filter( 'wp_title', 'igmg_wp_title', 10, 2 );

if ( ! isset( $content_width ) ) {
	$content_width = 600;
}

register_nav_menus( array(
    'primary' => __( 'Primary Menu', 'wpigmg' ),
) );

function side_widgets_init() {
		register_sidebar( array(
		'name'          => __( 'Main Sidebar', 'wpigmg' ),
		'id'            => 'sidebar-1',
		'description'   => __( 'Right sidebar', 'wpigmg' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'side_widgets_init' );



/* ADMIN SAYFASI AYARLARI
/*---------------------------------------------------
register settings
----------------------------------------------------*/
function theme_settings_init(){
register_setting( 'theme_settings', 'theme_settings' );
}

/*---------------------------------------------------
add settings page to menu
----------------------------------------------------*/
function add_settings_page() {
add_menu_page( __( 'WP IGMG' .' Tema Paneli' ), __( 'WP IGMG' .' Tema Paneli' ), 'manage_options', 'settings', 'theme_settings_page');
}

/*---------------------------------------------------
add actions
----------------------------------------------------*/
add_action( 'admin_init', 'theme_settings_init' );
add_action( 'admin_menu', 'add_settings_page' );
 
/*---------------------------------------------------
Theme Panel Output
----------------------------------------------------*/
function theme_settings_page() {
	if (!current_user_can('manage_options')) {
    wp_die('Bu Sayfayı görüntüleme yetkiniz yok.');
}
if(function_exists( 'wp_enqueue_media' )){
    wp_enqueue_media();
}else{
    wp_enqueue_style('thickbox');
    wp_enqueue_script('media-upload');
    wp_enqueue_script('thickbox');
}
if (isset($_POST["update_settings"])) {
	$logo = esc_attr($_POST["logo"]);  
	$logo_adres = esc_attr($_POST["logo_adres"]);  
	$slogan = esc_attr($_POST["slogan"]);  
	$takvim = esc_attr($_POST["takvim"]);  

	
	update_option("wpigmg_logo", $logo);
	update_option("wpigmg_logo_adres", $logo_adres);
	update_option("wpigmg_slogan", $slogan);
	update_option("wpigmg_takvim", $takvim);

	
	
	
	?>
    <div id="message" class="updated">Ayarlar Kaydedildi</div>
<?php
}
    ?>
     <div class="wrap">
         <div id="icon-options-general"></div>
         <h2><?php _e( 'Tema Ayarlari' ) //your admin panel title ?></h2>

			<script>
				jQuery(document).ready(function($) {
					$('.header_logo_upload').click(function(e) {
						e.preventDefault();

						var custom_uploader = wp.media({
							title: 'Logo Yükleme',
							button: {
								text: 'Resmi Yükle'
							},
							multiple: false  // Set this to true to allow multiple files to be selected
						})
						.on('select', function() {
							var attachment = custom_uploader.state().get('selection').first().toJSON();
							$('.header_logo_url').val(attachment.url);

						})
						.open();
					});
				});
			</script>
		 
		   <form method="POST" action="">
		   <input type="hidden" name="update_settings" value="Y" />
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">
                        <label for="logo">
                            Logo
                        </label> 
                    </th>
                    <td>
                        <input type="text" class="header_logo_url" value="<?php echo get_option("wpigmg_logo");?>" name="logo" size="75" /> <input type="button" value="Upload" class="button-primary header_logo_upload"> 
						<small>
								<br>Logo Genislik : 541 X Yükseklik : 70 Pixel olmasi tavsiye edilir.
						</small>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="logo">
                            Logo altı adres
                        </label> 
                    </th>
                    <td>
                        <textarea name="logo_adres" cols="100" rows="5"><?php echo get_option("wpigmg_logo_adres");?></textarea>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="logo">
                           Slogan
                        </label> 
                    </th>
                    <td>
                        <textarea name="slogan" cols="100" rows="5"><?php echo get_option("wpigmg_slogan");?></textarea>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="logo">
                           Google Takvim Url
                        </label> 
                    </th>
                    <td>
                        <textarea name="takvim" cols="100" rows="5"><?php echo get_option("wpigmg_takvim");?></textarea><br>
						<small>Asagida yazilmasi gereken alan kirmizi olarak belirtilmistir.<a href="https://support.google.com/calendar/answer/41207?hl=tr" target="_blank">Bu Kodu nasil olustururum?</a><br><br>
						
							&lt;iframe src="https://www.google.com/calendar/embed?showTitle=0&amp;amp;showPrint=0&amp;amp;showTabs=0&amp;amp;showCalendars=0&amp;amp;showTz=0&amp;amp;height=450<br>&amp;amp;wkst=1&amp;amp;bgcolor=%23FFFFFF&amp;amp;src=<font color="red">ek78ceb1v6m7em9383ki8nljms%40group.calendar.google.com</font>&amp;amp;color=%000000<br>&amp;amp;ctz=Europe%2FBerlin" style=" border-width:0 " width="100%" height="450" frameborder="0" scrolling="no"&gt;&lt;/iframe&gt;
						</small>
					</td>
                </tr>
            </table>
			 <p>
    <input type="submit" value="Ayarları Kaydet" class="button-primary"/>
</p>
			</form>
		 

		 
		 
		 
		 
		 
		 
 
         <div class="footer-credit">
            <p>WPIGMG 1.0 teması, <a title="IGMG" href="http://www.igmg.org" target="_blank" >IGMG</a> için <a title="IGMG Fatih Camii Lörrach" href="http://www.igmg-loerrach.de" target="_blank" >Lörrach Fatih Camii</a> tarafından hazırlanmıştır. <br>IGMG ile RESMİ BİR BAĞI YOKTUR. TAMAMEN GÖNÜLLÜ OLARAK YAPILMIŞTIR.</p>
         </div>
     </div>
     <?php
}
			
?>